/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod.names;

import com.endertech.minecraft.forge.coremod.names.Name;
import com.endertech.minecraft.forge.coremod.names.NotchMcp;

public class ClassName
extends Name {
    public static final String JAVA_DELIMITER = ".";
    public static final String INTERNAL_DELIMITER = "/";
    public final String java;

    protected ClassName(String normal, String obfuscated) {
        super(normal, obfuscated);
        this.java = ClassName.getJavaName(normal);
    }

    public static String join(String ... names) {
        return String.join((CharSequence)JAVA_DELIMITER, names);
    }

    public static ClassName from(String name) {
        String normal = ClassName.getInternalName(name);
        String obfuscated = NotchMcp.CLASSES.getOrDefault(normal, normal);
        return new ClassName(normal, obfuscated);
    }

    public static String getInternalName(String javaName) {
        return javaName.replace(JAVA_DELIMITER, INTERNAL_DELIMITER);
    }

    public static String getJavaName(String internalName) {
        return internalName.replace(INTERNAL_DELIMITER, JAVA_DELIMITER);
    }

    public String getSimpleName() {
        return this.java.substring(this.java.lastIndexOf(JAVA_DELIMITER) + 1);
    }

    @Override
    public boolean complyWith(String string) {
        return super.complyWith(string) || this.java.equals(string);
    }
}

